
/********************************************************************
Steffen von der Mikrocontrollerspielwiese schrieb diesen Code.

Er soll die Benutzung externer Interrupts veranschaulichen.

Das 10-Kanal-Lauflicht wird sofort unterbrochen (bleibt stehen),
wenn INT0 auf GND gelegt wird. Dann blinkt LED1. 
Kommt INT0 wieder von GND frei, luft das Lauflicht weiter.

have fun!

********************************************************************/

#include <avr/io.h>
#include <avr/interrupt.h>

#define F_CPU 1000000UL  	// 1 MHz 
#include <util/delay.h>

#include "leds.h"


//********************************************************************

// Interruptserviceroutine
// (= Routine, die im Interruptfall abgearbeitet wird)

ISR (INT0_vect) {

	led1on; _delay_ms(100); led1off;_delay_ms(100);
}  

//********************************************************************

int main(void){
	
	DDRB = 193; DDRD = 251;   			//Aus- und Eingnge festlegen
	PORTD |= _BV(PD2); 				//Pull Up an PD2 = INT0 aktivieren
	GICR |=(1<<INT0);   				//Ext. Interupt an INT0
	MCUCR |=(0<<ISC01) | (0<<ISC00);   	//Interrupt, wenn INT0 = GND
	sei();							//Interrupts erlauben
	
	
	while(1){
		
		led1on; _delay_ms(100); led1off;
		led2on; _delay_ms(100); led2off;
		led3on; _delay_ms(100); led3off;
		led4on; _delay_ms(100); led4off;
		led5on; _delay_ms(100); led5off;
		led6on; _delay_ms(100); led6off;
		led7on; _delay_ms(100); led7off;
		led8on; _delay_ms(100); led8off;
		led9on; _delay_ms(100); led9off;
		led10on; _delay_ms(100); led10off;
		
	}
 

	return 0;
}
//********************************************************************
