#include <TFT.h>  // Arduino LCD library
#include <SPI.h>

// benutzte Pins am Arduino UNO
#define cs   10
#define dc   9
#define rst  8

// das Objekt "TFTscreen" erschaffen:
TFT TFTscreen = TFT(cs, dc, rst);


void setup() {

  TFTscreen.begin();// Initialisierung

  TFTscreen.background(255, 255, 255);   // Hintergrundfarbe: weiß
  TFTscreen.setRotation(0); // 0:Pins unten | 1:Pins rechts

  //Text ausgeben:
   TFTscreen.stroke(255, 0, 0);
  TFTscreen.setTextSize(2);//Schriftgröße (kleinste:0)
  TFTscreen.text("Arduino-", 5, 10); // Text, x-Verschiebung, y-Verschiebung
  TFTscreen.text("spielwiese", 5, 30);


  // blaue Linie:
  TFTscreen.stroke(255, 0, 0); // blau
  TFTscreen.line(15, 80, 35, 65);


  // grünes Rechteck mit schwarzem Rand:
  TFTscreen.fill(0, 255, 0); // grüne Füllung
  TFTscreen.stroke(0, 0, 0); // schwarzer Rand
  TFTscreen.rect(50, 60, 20, 20); // x, y, breite, höhe


  // magentafarbenes Rechteck ohne Rand:
  TFTscreen.fill(255, 0, 255); // grüne Füllung
  TFTscreen.noStroke();    // kein Rand
  TFTscreen.rect(80, 60, 20, 20);


  // schwarze Sinuskurve
  double x, y; // Hilfsvariablen
  TFTscreen.stroke(0, 0, 0); // schwarz
  for (x = 0; x < 20 * 3.14; x = x + 0.05)  {
    y = 10 * sin(x / 10);
    TFTscreen.point(25 + x, 100 - y); // x, y
  }

  // roter Kreis
  TFTscreen.drawCircle(60, 130, 10, 255); //xMitte, yMitte, Radius, Farbe
}

void loop() {
  delay(500);
}
