// Dieses Programm benutzt die Bibliothek "u8g2" von oli kraus.
// Siehe dazu: https://github.com/olikraus/u8g2/wiki
// Referenz (mögliche Befehle): https://github.com/olikraus/u8g2/wiki/u8g2reference

// Dieses Programm wurde geschrieben von:	uli.baehr@hotmail.de
// Dieses Programm wurde erweitert von: steffen von der arduinospielwiese

// Im Arduino Ordner Arduino\libraries\U8g2\src\clib in der Datei
// u8g2.h in (etwa) Zeile 72 "//#define U8G2_16BIT" Auskommentierung aufheben --> fuer
// laengere Laufschrift

// Bibliothek von oli kraus:
#include <U8g2lib.h>

// Instanziierung:
U8G2_SSD1306_128X32_UNIVISION_F_SW_I2C u8g2(U8G2_R0, 5, 4, 16);

enum WIDTHSTATE
{
  total_width = 0,
  start_text,
  start_text2,
  start_text3,
  start_Pic1,
  start_Pic2,
  towi_inDisp,
  widthSTATE_size
};

enum ANIMATION
{
  pingu_ani_1 = 0,
  pingu_ani_2,
  pingu_ani_size
};

byte anima_pingu = pingu_ani_1;
bool pingu_switch = false;
u8g2_uint_t offset;
u8g2_uint_t width[widthSTATE_size];

int changePic = 1;

// Lauftext:
const char *text  = "Arduino";
const char *text2 = "spiel";
const char *text3 = "wiese";

/* --- Bilder ------------------------------------------------------------- */

#pragma region Pingu_Images.xbm
#define pingu_width 32
#define pingu_height 32

const unsigned char pingu1_bits[] = {
  0x00, 0xe0, 0x0f, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0x00, 0x98, 0x33, 0x00, 0x00, 0x0c, 0x61, 0x00, 0x00, 0x2c, 0x6d, 0x00,
  0x00, 0x1c, 0x71, 0x00, 0x00, 0x7c, 0x7a, 0x00, 0x00, 0x3c, 0x7c, 0x00,
  0x00, 0xfc, 0x78, 0x00, 0x00, 0x78, 0x3f, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0xe0, 0x0f, 0x00,
  0x00, 0xf8, 0x3f, 0x00, 0x00, 0x7c, 0x7a, 0x00, 0x00, 0x3e, 0xf8, 0x00,
  0x00, 0x0e, 0xe0, 0x00, 0x00, 0x0f, 0xe0, 0x01, 0x80, 0x07, 0xc0, 0x03,
  0xc0, 0x07, 0xc0, 0x07, 0xe0, 0x07, 0xc0, 0x0f, 0xf0, 0x07, 0xc0, 0x1f,
  0xf8, 0x0f, 0xc0, 0x3f, 0xb4, 0x0f, 0xe0, 0x77, 0xcc, 0x1f, 0xf0, 0x55,
  0xb8, 0x7f, 0xfa, 0x37, 0xd0, 0xff, 0xff, 0x1f, 0xe0, 0xfe, 0x7f, 0x0d,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x01
};

const unsigned char pingu2_bits[] = {
  0x00, 0xe0, 0x0f, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0x00, 0x38, 0x66, 0x00, 0x00, 0x3c, 0x44, 0x00, 0x00, 0xbc, 0x59, 0x00,
  0x00, 0x7c, 0x66, 0x00, 0x00, 0xfc, 0x77, 0x00, 0x00, 0xfc, 0x49, 0x00,
  0x00, 0xf8, 0x73, 0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x35, 0x00, 0x00, 0xf8, 0x60, 0x00, 0x00, 0xf8, 0x41, 0x00,
  0x00, 0xf8, 0xe1, 0x00, 0x00, 0xf8, 0xc3, 0x01, 0x00, 0xfc, 0x87, 0x03,
  0x00, 0xfc, 0x8f, 0x07, 0x00, 0xfc, 0xbe, 0x0f, 0x00, 0xfc, 0xfc, 0x3f,
  0x00, 0xfc, 0xf5, 0x2c, 0x00, 0xf8, 0xd5, 0x79, 0x00, 0xf8, 0xf7, 0x6d,
  0x00, 0xf8, 0xef, 0x6f, 0x00, 0xfc, 0xf7, 0x1d, 0x00, 0xf8, 0xff, 0x1f,
  0x00, 0x00, 0x6d, 0x04, 0x00, 0x00, 0x1c, 0x00
};

const unsigned char pingu3_bits[] = {
  0x00, 0xe0, 0x0f, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0x00, 0xfc, 0x31, 0x00, 0x00, 0xfc, 0x61, 0x00, 0x00, 0xfc, 0x6d, 0x00,
  0x00, 0xfc, 0x71, 0x00, 0x00, 0xfc, 0x9f, 0x00, 0x00, 0xfc, 0x27, 0x01,
  0x00, 0xf8, 0xaf, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x0f, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf0, 0x3f, 0x00,
  0x00, 0xf8, 0x67, 0x00, 0x00, 0xf8, 0xc3, 0x00, 0x00, 0xf8, 0x87, 0x00,
  0x00, 0xf8, 0x8f, 0x01, 0x00, 0xfc, 0xbf, 0x03, 0x00, 0xfc, 0xff, 0x07,
  0x00, 0xfc, 0xff, 0x1f, 0x00, 0xfc, 0x87, 0x3f, 0x00, 0xfc, 0x0f, 0x6f,
  0x00, 0xfc, 0x3f, 0x5b, 0x00, 0xfc, 0x3f, 0xdb, 0x00, 0xfc, 0xff, 0xef,
  0x00, 0xfc, 0xff, 0x5c, 0x00, 0xfe, 0xff, 0x77, 0x80, 0xff, 0xff, 0x37,
  0x00, 0x16, 0x55, 0x0d, 0x00, 0x00, 0x00, 0x03
};

const unsigned char pingu4_bits[] = {
  0x00, 0xe0, 0x0f, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0xf8, 0x1f, 0x00,
  0x00, 0xf8, 0x3f, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfc, 0x7f, 0x00,
  0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfc, 0x7f, 0x00,
  0x00, 0xfc, 0x7f, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0xf8, 0x7f, 0x00,
  0x00, 0xf8, 0x7f, 0x00, 0x00, 0xf8, 0xff, 0x00, 0x00, 0xfc, 0xff, 0x01,
  0x00, 0xfc, 0xff, 0x03, 0x00, 0xfc, 0xff, 0x07, 0x00, 0xfc, 0xff, 0x1f,
  0x00, 0xfc, 0xff, 0x3f, 0x00, 0xfc, 0xff, 0x6d, 0x00, 0xf8, 0xff, 0x58,
  0x00, 0xf8, 0xff, 0x7b, 0x00, 0xfc, 0xff, 0x2f, 0x00, 0xfc, 0xff, 0x1d,
  0x00, 0xd8, 0x7f, 0x0f, 0x00, 0x00, 0x3d, 0x0c
};

const unsigned char pingu5_bits[] = {
  0x00, 0xe0, 0x0f, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0x00, 0xfc, 0x3f, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfc, 0x7f, 0x00,
  0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfc, 0x7f, 0x00,
  0x00, 0xfc, 0x3f, 0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00, 0xf8, 0x1f, 0x00,
  0x00, 0xe0, 0x0f, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0xf0, 0x0f, 0x00,
  0x00, 0xf8, 0x1f, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 0xff, 0xff, 0x00,
  0x00, 0xff, 0xff, 0x01, 0xc0, 0xff, 0xff, 0x03, 0xc0, 0xff, 0xff, 0x07,
  0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xd0, 0xff, 0xff, 0x1b,
  0xec, 0xff, 0xff, 0x37, 0xac, 0xff, 0xff, 0x6f, 0xf4, 0xff, 0xff, 0x6f,
  0xd8, 0xff, 0xff, 0x2d, 0x70, 0xff, 0xff, 0x1e, 0xe0, 0xff, 0xff, 0x0b,
  0x80, 0xf1, 0x8f, 0x03, 0x00, 0x01, 0x00, 0x01
};

const unsigned char pingu6_bits[] = {
  0x00, 0xe0, 0x07, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xf8, 0x1f, 0x00,
  0x00, 0xfc, 0x3f, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfe, 0x7f, 0x00,
  0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfe, 0x7f, 0x00, 0x00, 0xfc, 0x7f, 0x00,
  0x00, 0xfe, 0x7f, 0x00, 0x00, 0xfc, 0x3f, 0x00, 0x00, 0xf8, 0x1f, 0x00,
  0x00, 0xf0, 0x0f, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xf8, 0x0f, 0x00,
  0x00, 0xf8, 0x1f, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0xfc, 0x3f, 0x00,
  0x00, 0xfe, 0x3f, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x80, 0xff, 0x7f, 0x00,
  0xc0, 0xff, 0x7f, 0x00, 0xe0, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00,
  0xf8, 0xff, 0x7f, 0x00, 0x3e, 0xff, 0x7f, 0x00, 0x26, 0xff, 0x3f, 0x00,
  0xbe, 0xff, 0x3f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x68, 0xff, 0x7f, 0x00,
  0x70, 0xff, 0x0b, 0x00, 0x20, 0x78, 0x00, 0x00
};

const unsigned char pingu7_bits[] = {
  0x00, 0xf8, 0x07, 0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 0xdc, 0x1f, 0x00,
  0x00, 0x86, 0x3f, 0x00, 0x00, 0x96, 0x3f, 0x00, 0x00, 0x96, 0x3f, 0x00,
  0x00, 0xee, 0x3f, 0x00, 0x00, 0xf5, 0x3f, 0x00, 0x80, 0xf0, 0x3f, 0x00,
  0x00, 0xf7, 0x1f, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0xf8, 0x0f, 0x00,
  0x00, 0xf8, 0x07, 0x00, 0x00, 0xfc, 0x0f, 0x00, 0x00, 0xf6, 0x0f, 0x00,
  0x00, 0xe2, 0x0f, 0x00, 0x80, 0xc3, 0x1f, 0x00, 0x80, 0xf1, 0x1f, 0x00,
  0x80, 0xf8, 0x1f, 0x00, 0xc0, 0xff, 0x3f, 0x00, 0xf0, 0xff, 0x3f, 0x00,
  0xfc, 0xef, 0x3f, 0x00, 0xfc, 0xf0, 0x3f, 0x00, 0x7e, 0xf8, 0x3f, 0x00,
  0xc9, 0xfc, 0x3f, 0x00, 0xfb, 0xfe, 0x3f, 0x00, 0xaf, 0xff, 0x3f, 0x00,
  0xbc, 0xff, 0x3f, 0x00, 0xf6, 0xff, 0x7f, 0x00, 0xac, 0xdf, 0xff, 0x00,
  0xf0, 0x28, 0x28, 0x00, 0x40, 0x00, 0x00, 0x00
};

const unsigned char pingu8_bits[] = {
  0x00, 0xf0, 0x07, 0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 0xfc, 0x1f, 0x00,
  0x00, 0x76, 0x1e, 0x00, 0x00, 0x22, 0x3c, 0x00, 0x00, 0xaa, 0x3c, 0x00,
  0x00, 0x76, 0x3e, 0x00, 0x00, 0xe6, 0x3f, 0x00, 0x00, 0xca, 0x3f, 0x00,
  0x00, 0x96, 0x1f, 0x00, 0x00, 0xfe, 0x1f, 0x00, 0x00, 0xfc, 0x0f, 0x00,
  0x00, 0xf8, 0x07, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 0xf8, 0x07, 0x00,
  0x00, 0xdc, 0x0f, 0x00, 0x00, 0x06, 0x0f, 0x00, 0x00, 0x06, 0x1f, 0x00,
  0x00, 0xc3, 0x1f, 0x00, 0x80, 0xc3, 0x1f, 0x00, 0xc0, 0xe1, 0x3f, 0x00,
  0xe0, 0xf1, 0x3f, 0x00, 0xf0, 0x7d, 0x3f, 0x00, 0xf8, 0x3d, 0x3f, 0x00,
  0xbc, 0x9f, 0x3f, 0x00, 0x96, 0xb7, 0x1f, 0x00, 0x9a, 0xeb, 0x1f, 0x00,
  0xf6, 0xef, 0x1f, 0x00, 0xbc, 0xf7, 0x3f, 0x00, 0xf8, 0xff, 0x1f, 0x00,
  0x30, 0xef, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00
};

const unsigned char pingu10_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf8, 0x3f, 0x00, 0x00, 0x98, 0x33, 0x00, 0x00, 0x0c, 0x61, 0x00,
  0x00, 0x2c, 0x6d, 0x00, 0x00, 0x3c, 0x71, 0x00, 0x00, 0xbc, 0x7e, 0x00,
  0x00, 0xbc, 0x78, 0x00, 0x00, 0x78, 0x7f, 0x00, 0x00, 0xf8, 0x3e, 0x00,
  0x00, 0xf0, 0x1f, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0xe0, 0x1f, 0x00,
  0x00, 0xf8, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x73,
  0xa8, 0x3f, 0xf8, 0x2f, 0xf0, 0xff, 0xff, 0x17, 0x60, 0xff, 0x7f, 0x0f,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu11_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0xe0, 0x3f, 0x00,
  0x00, 0xf0, 0x7f, 0x00, 0x00, 0x38, 0x63, 0x00, 0x00, 0x18, 0xc2, 0x00,
  0x00, 0x38, 0xca, 0x00, 0x00, 0x38, 0xea, 0x00, 0x00, 0xf8, 0xfa, 0x00,
  0x00, 0xf8, 0xf4, 0x00, 0x00, 0x78, 0x7d, 0x00, 0x00, 0xf0, 0x7d, 0x00,
  0x00, 0xe0, 0x3f, 0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x55,
  0xa8, 0x3f, 0xf8, 0x37, 0xf0, 0xff, 0xff, 0x1f, 0x60, 0xff, 0xff, 0x0e,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu12_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
  0x00, 0xf0, 0xff, 0x00, 0x00, 0x30, 0xc6, 0x00, 0x00, 0x30, 0xc4, 0x01,
  0x00, 0x78, 0x9a, 0x01, 0x00, 0x70, 0xd2, 0x01, 0x00, 0xf8, 0xea, 0x00,
  0x00, 0x78, 0xf5, 0x01, 0x00, 0xf0, 0xfa, 0x00, 0x00, 0xf0, 0xfb, 0x00,
  0x00, 0xe0, 0x7f, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xc0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x73,
  0xa8, 0x3f, 0xf8, 0x2f, 0xf0, 0xff, 0xff, 0x17, 0x60, 0xff, 0x7f, 0x0f,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu13_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
  0x00, 0xf0, 0xff, 0x00, 0x00, 0x30, 0xc6, 0x00, 0x00, 0x30, 0xc4, 0x01,
  0x00, 0xb8, 0x94, 0x01, 0x00, 0xb0, 0xe4, 0x01, 0x00, 0xf8, 0xfa, 0x00,
  0x00, 0xf0, 0xe2, 0x01, 0x00, 0xf0, 0xfa, 0x00, 0x00, 0xf0, 0xff, 0x00,
  0x00, 0xe0, 0x7f, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xc0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x55,
  0x98, 0x3f, 0xf8, 0x37, 0xf0, 0xff, 0xff, 0x1f, 0x60, 0xff, 0xff, 0x0e,
  0xc0, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu14_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0xe0, 0x3f, 0x00,
  0x00, 0xf0, 0x7f, 0x00, 0x00, 0x38, 0x63, 0x00, 0x00, 0x18, 0xc2, 0x00,
  0x00, 0xd8, 0xf2, 0x00, 0x00, 0x38, 0xe2, 0x00, 0x00, 0xf8, 0xfa, 0x00,
  0x00, 0x78, 0xf5, 0x00, 0x00, 0xf8, 0x7a, 0x00, 0x00, 0xf0, 0x7f, 0x00,
  0x00, 0xe0, 0x3f, 0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x55,
  0xa8, 0x3f, 0xf8, 0x37, 0xf0, 0xff, 0xff, 0x1f, 0x60, 0xff, 0xff, 0x0e,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu15_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf8, 0x3f, 0x00, 0x00, 0x98, 0x33, 0x00, 0x00, 0x0c, 0x60, 0x00,
  0x00, 0xcc, 0x79, 0x00, 0x00, 0x1c, 0x71, 0x00, 0x00, 0x7c, 0x7d, 0x00,
  0x00, 0xbc, 0x7a, 0x00, 0x00, 0x78, 0x3d, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0x00, 0xf0, 0x1f, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0xe0, 0x1f, 0x00,
  0x00, 0xf8, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x55,
  0xa8, 0x3f, 0xf8, 0x37, 0xf0, 0xff, 0xff, 0x1f, 0x60, 0xff, 0xff, 0x0d,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu16_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf8, 0x3f, 0x00, 0x00, 0x98, 0x33, 0x00, 0x00, 0x0c, 0x60, 0x00,
  0x00, 0xcc, 0x79, 0x00, 0x00, 0x1c, 0x71, 0x00, 0x00, 0x7c, 0x7d, 0x00,
  0x00, 0xbc, 0x7a, 0x00, 0x00, 0x78, 0x3d, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0x00, 0xf0, 0x1f, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0xe0, 0x1f, 0x00,
  0x00, 0xf8, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x55,
  0xa8, 0x3f, 0xf8, 0x37, 0xf0, 0xff, 0xff, 0x1f, 0x60, 0xff, 0xff, 0x0d,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu17_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0xf8, 0x0f, 0x00,
  0x00, 0xfc, 0x1f, 0x00, 0x00, 0x8c, 0x39, 0x00, 0x00, 0x8e, 0x30, 0x00,
  0x00, 0xc6, 0x3c, 0x00, 0x00, 0x8e, 0x38, 0x00, 0x00, 0xbe, 0x3e, 0x00,
  0x00, 0xbe, 0x3c, 0x00, 0x00, 0xbc, 0x3e, 0x00, 0x00, 0xfc, 0x1f, 0x00,
  0x00, 0xf8, 0x0f, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x3f, 0x00, 0x00, 0xfc, 0x7d, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x07, 0xe0, 0x1f,
  0xe0, 0x06, 0xc0, 0x1d, 0x60, 0x07, 0xc0, 0x0e, 0xd0, 0x07, 0xc0, 0x1b,
  0xb8, 0x07, 0xc0, 0x37, 0xd4, 0x0f, 0xe0, 0x6f, 0xac, 0x1f, 0xf0, 0x73,
  0xf8, 0x3f, 0xf8, 0x2f, 0xd0, 0xff, 0xff, 0x17, 0x60, 0xff, 0x7f, 0x0f,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu18_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0xfc, 0x0f, 0x00,
  0x00, 0xfc, 0x0f, 0x00, 0x00, 0xc6, 0x18, 0x00, 0x00, 0x87, 0x18, 0x00,
  0x00, 0x63, 0x3c, 0x00, 0x00, 0xc7, 0x1c, 0x00, 0x00, 0x1f, 0x3f, 0x00,
  0x00, 0xbf, 0x3c, 0x00, 0x00, 0x5e, 0x1f, 0x00, 0x00, 0xfe, 0x1f, 0x00,
  0x00, 0xfc, 0x0f, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 0xf0, 0x0f, 0x00,
  0x00, 0xf0, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x73,
  0xa8, 0x3f, 0xf8, 0x2f, 0xf0, 0xff, 0xff, 0x17, 0x60, 0xff, 0x7f, 0x0f,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu19_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0xfc, 0x0f, 0x00,
  0x00, 0xfe, 0x0f, 0x00, 0x00, 0xc6, 0x1c, 0x00, 0x00, 0x47, 0x18, 0x00,
  0x00, 0x53, 0x3a, 0x00, 0x00, 0xa7, 0x18, 0x00, 0x00, 0x5f, 0x3f, 0x00,
  0x00, 0x5f, 0x3e, 0x00, 0x00, 0x5e, 0x1f, 0x00, 0x00, 0xfe, 0x1f, 0x00,
  0x00, 0xfc, 0x0f, 0x00, 0x00, 0xf8, 0x07, 0x00, 0x00, 0xf0, 0x0f, 0x00,
  0x00, 0xf0, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xc0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x55,
  0xa8, 0x3f, 0xf8, 0x37, 0xf0, 0xff, 0xff, 0x1f, 0x60, 0xff, 0xff, 0x0e,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

const unsigned char pingu20_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0xf8, 0x0f, 0x00,
  0x00, 0xfc, 0x1f, 0x00, 0x00, 0xcc, 0x39, 0x00, 0x00, 0x86, 0x30, 0x00,
  0x00, 0xb6, 0x32, 0x00, 0x00, 0x0e, 0x39, 0x00, 0x00, 0x7e, 0x3d, 0x00,
  0x00, 0x5e, 0x3d, 0x00, 0x00, 0xbc, 0x3e, 0x00, 0x00, 0xfc, 0x1f, 0x00,
  0x00, 0xf8, 0x0f, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0xf0, 0x1f, 0x00,
  0x00, 0xf0, 0x3f, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x3f, 0xf8, 0x01,
  0x80, 0x1f, 0xf0, 0x03, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x1f,
  0x60, 0x06, 0xc0, 0x1d, 0xe0, 0x07, 0xc0, 0x0e, 0xb0, 0x07, 0xc0, 0x1b,
  0xd8, 0x07, 0xc0, 0x37, 0xac, 0x0f, 0xe0, 0x6f, 0xec, 0x1f, 0xf0, 0x55,
  0xa8, 0x3f, 0xf8, 0x37, 0xf0, 0xff, 0xff, 0x1f, 0x60, 0xff, 0xff, 0x0e,
  0x80, 0xf3, 0x9f, 0x03, 0x00, 0x01, 0x00, 0x03
};

#pragma endregion


/* --- setup ------------------------------------------------------------- */
void setup(void) {
  u8g2.begin();
  u8g2.enableUTF8Print();
  u8g2.setFont(u8g2_font_mozart_nbp_tf);

  get_startXpos();

  u8g2.setFontMode(0);
}


/* --- loop ------------------------------------------------------------- */
void loop(void) {
  u8g2_uint_t x;

  u8g2.firstPage();
  do {
    x = offset;

    u8g2.setFont(u8g2_font_mozart_nbp_tf);

    do {
      //Pingu-Image wechsel
      if (pingu_switch)	{
        if (anima_pingu == pingu_ani_1)anima_pingu = pingu_ani_2;
        else anima_pingu = pingu_ani_1;
      }

      //Pingu-Image auf display
      draw_Pingu(x + width[start_Pic1], changePic, anima_pingu);

      //dann der Text:
      u8g2.drawUTF8(x + width[start_text], 10, text);
      u8g2.drawUTF8(x + width[start_text2], 20, text2);
      u8g2.drawUTF8(x + width[start_text3], 30, text3);

      x += width[total_width];
      pingu_switch = true;
    } while (x < u8g2.getDisplayWidth());
    pingu_switch = false;

  } while (u8g2.nextPage());

  if (pingu_switch) pingu_switch = false;
  //else pingu_switch = true;
  offset -= 1;
  //Animation von vorn beginnen
  if (changePic == 9 && anima_pingu == pingu_ani_1)changePic = 1;		//bei Ende von Bildfolge1: Bildfolge von vorn
  if (changePic == 10 && anima_pingu == pingu_ani_2)changePic = 1;	//bei Ende von Bildfolge2: Bildfolge von vorn
  if (changePic < 10) changePic++;

  //Animationswechsel
  if ((u8g2_uint_t)offset < (u8g2_uint_t) - (width[total_width])) {
    offset = 0;
    u8g2.clearBuffer();
  }
}//end loop

/*---- eigene Methoden -------------------------------------------------------------------------------------------------------------*/
void draw_Pingu(u8g2_uint_t x, int changeAniPic, byte anima_pingu) {
  if (anima_pingu == pingu_ani_2)changeAniPic += 9;
  switch (changeAniPic)
  {
    //1.Animation
    case 1:
      //u8g2.drawXBM("x-Pos", "y-Pos", "bitmap-width", "bitmap-hight", "Bitmap.xbm");		//Am besten mit Gimp in schwarz-weiss wandeln
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu1_bits);		//und mit der Endung .xbm exportieren.
      break;																												//Datei im Editor Oeffnen und freuen
    case 2:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu2_bits);
      break;
    case 3:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu3_bits);
      break;
    case 4:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu4_bits);
      break;
    case 5:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu5_bits);
      break;
    case 6:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu6_bits);
      break;
    case 7:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu7_bits);
      break;
    case 8:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu8_bits);
      break;
    //2.Animation
    case 10:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu10_bits);
      break;
    case 11:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu11_bits);
      break;
    case 12:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu12_bits);
      break;
    case 13:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu13_bits);
      break;
    case 14:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu14_bits);
      break;
    case 15:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu15_bits);
      break;
    case 16:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu16_bits);
      break;
    case 17:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu17_bits);
      break;
    case 18:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu18_bits);
      break;
    case 19:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu19_bits);
      break;
    case 20:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu20_bits);
      break;

    default:
      u8g2.drawXBM(x, 0, pingu_width, pingu_height, pingu1_bits);
      break;
  }
}// end draw_Pingu

void get_startXpos() {
  /* laengsten Text ermitteln ==>...*/
  if (u8g2.getUTF8Width(text) >= u8g2.getUTF8Width(text2)) {

    if (u8g2.getUTF8Width(text) >= u8g2.getUTF8Width(text3))
    {
      width[total_width] = pingu_width + u8g2.getUTF8Width(text); //==>...Gesamtlaenge Bild+Text ermitteln
      u8g2_uint_t foo = 0;	do foo++;	while ((foo * width[total_width]) <= u8g2.getDisplayWidth());
      width[towi_inDisp] = foo;
      width[start_Pic1] = (u8g2.getDisplayWidth() / width[towi_inDisp] - (width[total_width]));
      width[start_text]  = width[start_Pic1] + pingu_width;
      //width[total_width] = width[start_text] + u8g2.getUTF8Width(text);
      width[start_text2] = width[start_text] + (u8g2.getUTF8Width(text) - u8g2.getUTF8Width(text2)) / 2;	// Text2 zentriert unter Text
      width[start_text3] = width[start_text] + (u8g2.getUTF8Width(text) - u8g2.getUTF8Width(text3)) / 2;
      //width[start_Pic2] = width[start_text] + u8g2.getUTF8Width(text);
    }

    if (u8g2.getUTF8Width(text) < u8g2.getUTF8Width(text3))
    {
      width[total_width] = pingu_width + u8g2.getUTF8Width(text3); //==>...Gesamtlaenge Bild+Text ermitteln
      u8g2_uint_t foo = 0;	do foo++;	while ((foo * width[total_width]) <= u8g2.getDisplayWidth());
      width[towi_inDisp] = foo;
      width[start_Pic1] = (u8g2.getDisplayWidth() / width[towi_inDisp] - (width[total_width]));
      width[start_text3] = width[start_Pic1] + pingu_width;
      //width[total_width] = width[start_text3]+ u8g2.getUTF8Width(text3);
      width[start_text] = width[start_text3] + (u8g2.getUTF8Width(text3) - u8g2.getUTF8Width(text)) / 2;
      width[start_text2] = width[start_text3] + (u8g2.getUTF8Width(text3) - u8g2.getUTF8Width(text2)) / 2;
      //width[start_Pic2] = width[start_text3] + u8g2.getUTF8Width(text3);
    }
  }

  if (u8g2.getUTF8Width(text) < u8g2.getUTF8Width(text2)) {

    if (u8g2.getUTF8Width(text2) >= u8g2.getUTF8Width(text3))
    {
      width[total_width] = pingu_width + u8g2.getUTF8Width(text2); //==>...Gesamtlaenge Bild+Text ermitteln
      u8g2_uint_t foo = 0;	do foo++;	while ((foo * width[total_width]) <= u8g2.getDisplayWidth());
      width[towi_inDisp] = foo;
      //width[start_Pic1] = (u8g2.getDisplayWidth() - (width[total_width] * width[towi_inDisp]) / 2);
      width[start_Pic1] = (u8g2.getDisplayWidth() / width[towi_inDisp] - (width[total_width]));
      width[start_text2] = width[start_Pic1] + pingu_width;
      //width[total_width] = width[start_text2] + u8g2.getUTF8Width(text2);
      width[start_text] = width[start_text2] + (u8g2.getUTF8Width(text2) - u8g2.getUTF8Width(text)) / 2;
      width[start_text3] = width[start_text2] + (u8g2.getUTF8Width(text2) - u8g2.getUTF8Width(text3)) / 2;
      //width[start_Pic2] = width[start_text2] + u8g2.getUTF8Width(text2);
    }

    if (u8g2.getUTF8Width(text2) < u8g2.getUTF8Width(text3))
    {
      width[total_width] = pingu_width + u8g2.getUTF8Width(text3); //==>...Gesamtlaenge Bild+Text ermitteln
      u8g2_uint_t foo = 0;	do foo++;	while ((foo * width[total_width]) <= u8g2.getDisplayWidth());
      width[towi_inDisp] = foo;
      width[start_Pic1] = (u8g2.getDisplayWidth() / width[towi_inDisp] - (width[total_width]));
      width[start_text3] = width[start_Pic1] + pingu_width;

      width[start_text] = width[start_text3] + (u8g2.getUTF8Width(text3) - u8g2.getUTF8Width(text)) / 2;
      width[start_text2] = width[start_text3] + (u8g2.getUTF8Width(text3) - u8g2.getUTF8Width(text2)) / 2;

    }
  }
} // end get_startXpos
